#define FONTSHEETCOLS 12
#define FONTSHEETROWS 8
void dtPrint(Csprite font, const char* text, ...)
{
    /*
	 !"#$%&'()*+
	,-./01234567
	89:;<=>?@ABC
	DEFGHIJKLMNO
	PQRSTUVWXYZ[
	\]^_'abcdefg
	hijklmnopqrs
	tuvwxyz
	
	The max font width is 85px
    */
    char string[256];                  // Temporary string
    va_list ap;
    if(text == NULL)
	return;
    va_start(ap, text);
	vsprintf(string, text, ap);
    va_end(ap);

    int txtlen=strlen(string);
    int charToPrint;
    int srcCol, srcRow;
    font.w = font.texture.w / FONTSHEETCOLS;
    font.h = font.texture.h / FONTSHEETROWS;
    for(int n = 0; n < txtlen; n++)
    {
	int curchar=string[n];
	charToPrint = curchar - 32; // our font file starts on ASCII 32 (blank space)
	srcRow = int(charToPrint / FONTSHEETCOLS);
	srcCol = charToPrint - (srcRow * FONTSHEETCOLS);


	font.srcX = srcCol * font.w;
	font.srcY = srcRow * font.h;

	renderSprite(font);
	font.x += font.w;
    }
}
