Csprite menuBackground;
Csprite menuFont;

void loadMenuData()
{
    menuBackground = initSprite();
    menuBackground.texture = loadTexture(DATADIR "/gfx/menuBackground.p");
    menuBackground.w = menuBackground.texture.w;
    menuBackground.h = menuBackground.texture.h;

#ifndef ANDROID
	SmenuPlay = initSprite();
	SmenuPlay.texture = loadTexture(DATADIR "/gfx/menuPlay.p");
	SmenuPlay.w = SmenuPlay.texture.w;
	SmenuPlay.h = SmenuPlay.texture.h;
	SmenuPlay.x = (SCREEN_WIDTH - SmenuPlay.w) / 2;
	SmenuPlay.y = ((SCREEN_HEIGHT - SmenuPlay.h) / 2) - SmenuPlay.h / 1.5;

	SmenuExit = initSprite();
	SmenuExit.texture = loadTexture(DATADIR "/gfx/menuExit.p");
	SmenuExit.w = SmenuExit.texture.w;
	SmenuExit.h = SmenuExit.texture.h;
	SmenuExit.x = (SCREEN_WIDTH - SmenuExit.w) / 2;
	SmenuExit.y = ((SCREEN_HEIGHT - SmenuExit.h) / 2) + SmenuExit.h / 1.5;
#endif

    menuFont = initSprite();
    menuFont.texture = loadTexture(DATADIR "/fonts/mainMenu.p");
    menuFont.w = menuFont.texture.w / FONTSHEETCOLS;
    menuFont.h = menuFont.texture.h / FONTSHEETROWS;

    Smedals = initSprite();
    Smedals.texture = loadTexture(DATADIR "/gfx/medals.p");
    Smedals.w = Smedals.texture.w / 3;
    Smedals.h = Smedals.texture.h;
    Smedals.scaleX = 0.5;
    Smedals.scaleY = 0.5;
    Smedals.x = 700;
    Smedals.y = 265;

    Svolume = initSprite();
    Svolume.texture = loadTexture(DATADIR "/gfx/volume.p");
    Svolume.w = Svolume.texture.w;
    Svolume.h = Svolume.texture.h / 11; // 11 is the volume level graphics (from 0 to 10)

    music = Mix_LoadMUS(DATADIR "/music/gameMusic.s3m");
}

void deleteMenuData()
{
    glDeleteTextures(1, &menuBackground.texture.id);
    glDeleteTextures(1, &SmenuPlay.texture.id);
    glDeleteTextures(1, &SmenuExit.texture.id);
    glDeleteTextures(1, &menuFont.texture.id);
    glDeleteTextures(1, &Smedals.texture.id);
    glDeleteTextures(1, &Svolume.texture.id);
}

int menuEvents()
{
    SDL_Event menuEvent;
    int mouseX, mouseY;
    int option = 0;

    while(SDL_PollEvent(&menuEvent))
    {
	SDL_GetMouseState(&mouseX, &mouseY);
#ifndef ANDROID
	if(menuEvent.type == SDL_QUIT)
		option = EXITGAME;
#endif
	if(menuEvent.type == SDL_KEYDOWN)
	{
	    if(menuEvent.key.keysym.sym == SDLK_ESCAPE)
			option = EXITGAME;
	    else if(menuEvent.key.keysym.sym == KEYVOLUMEDOWN)
	    {
			volumeOSDTime = VOLUMEOSDTIME;
			overallVolume--;
	    }
	    else if(menuEvent.key.keysym.sym == KEYVOLUMEUP)
	    {
			volumeOSDTime = VOLUMEOSDTIME;
    		overallVolume++;
		}
	    flushEvents();
	}
	else if(menuEvent.type == SDL_MOUSEBUTTONDOWN)
	{
	    /* check level chooser */
	    if(mouseY > 250 && mouseY < 312 && mouseX > 649 && mouseX < 785)
		{
			if(mouseX > 649 && mouseX < 688)
    	    	levelNumber--;
			if(mouseX > 748 && mouseX < 785)
	    	    levelNumber++;
			if(levelNumber < 1)
	    	    levelNumber = maxLevel;
			if(levelNumber > maxLevel)
	    	    levelNumber = 1;
    	}
		else
		{
#ifdef ANDROID
    		option = PLAYGAME;
#else
			if(mouseX > SmenuPlay.x && mouseX < SmenuPlay.x + SmenuPlay.w && mouseY > SmenuPlay.y && mouseY < SmenuPlay.y + SmenuPlay.h)
				option = PLAYGAME;
			if(mouseX > SmenuExit.x && mouseX < SmenuExit.x + SmenuExit.w && mouseY > SmenuExit.y && mouseY < SmenuExit.y + SmenuExit.h)
				option = EXITGAME;
#endif
		}
	    menuEvent.type = SDL_MOUSEBUTTONUP;
	}
    }
    return(option);
}

int doMenu()
{
    loadMenuData();
    loadScores();
    levelNumber = maxLevel;
    clearScreen(0, 0, 0, 1);

    int option = 0;
#ifdef ANDROID
    float OSDTime = 0.5; // time for "tap screen to play" text in secs.
    bool showOSD = true;
#endif
    char text[20];
    flushEvents();
    while(option == 0)
    {
	option = menuEvents();

	menuFont.y = 268;
	menuFont.x = 704;
	if(levelNumber >= 10)
	    menuFont.x -= menuFont.w / 2;
    	renderSprite(menuBackground);
	dtPrint(menuFont, "%d", levelNumber);

#ifdef ANDROID
	if(showOSD)
	{
	    sprintf(text, "Tap screen to play");
	    menuFont.x = (SCREEN_WIDTH - (strlen(text) * menuFont.w)) / 2;
	    menuFont.y = (SCREEN_HEIGHT - menuFont.h * 2) / 2;
	    dtPrint(menuFont, text);
	    if(OSDTime < 0)
	    {
		showOSD = false;
		OSDTime = 0.5;
	    }
	}
	else
	{
	    if(OSDTime < 0)
	    {
		showOSD = true;
		OSDTime = 0.5;
	    }
	}
#else

/* Hilight undermouse item */
	int mouseX, mouseY;
	SDL_GetMouseState(&mouseX, &mouseY);
	if(mouseX > SmenuPlay.x && mouseX < SmenuPlay.x + SmenuPlay.w && mouseY > SmenuPlay.y && mouseY < SmenuPlay.y + SmenuPlay.h)
		renderSprite(SmenuPlay);
	if(mouseX > SmenuExit.x && mouseX < SmenuExit.x + SmenuExit.w && mouseY > SmenuExit.y && mouseY < SmenuExit.y + SmenuExit.h)
		renderSprite(SmenuExit);
/* ----- */

	renderSprite(SmenuPlay);
	sprintf(text, "Play");
	menuFont.x = (SCREEN_WIDTH - strlen(text) * menuFont.w) /2;
	menuFont.y = SmenuPlay.y + (SmenuPlay.h - menuFont.h) / 2;
	dtPrint(menuFont, text);
	renderSprite(SmenuExit);
	sprintf(text, "Exit");
	menuFont.x = (SCREEN_WIDTH - strlen(text) * menuFont.w) /2;
	menuFont.y = SmenuExit.y + (SmenuExit.h - menuFont.h) / 2;
	dtPrint(menuFont, text);

#endif

	if(mlevel[levelNumber].medal > 0)
	{
	    Smedals.srcX = (mlevel[levelNumber].medal - 1) * Smedals.w;
	    renderSprite(Smedals);
	}
	showVolumeStatus();
	SDL_GL_SwapBuffers();
	playMusic();
	timing();
#ifdef ANDROID
	OSDTime -=loopTime;
#endif
        SDL_Delay(5);
    }
    stopMusic();
    deleteMenuData();
    return(option);
}
