#define SCREEN_WIDTH  800
#define SCREEN_HEIGHT 480
#define SCREEN_BPP     16

#define TRUE  1
#define FALSE 0

SDL_Surface *screen;

int initGL(void)
{
    glClearColor(0, 0, 0, 0);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_ALPHA_TEST);
    glEnable(GL_BLEND);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);

    glAlphaFunc(GL_GREATER, 0.01);
#ifndef ANDROID
// #define glOrthof glOrtho
#endif
    glOrthof(0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, -1, 1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    if(glGetError() != GL_NO_ERROR)
	return(FALSE);
    else
	return(TRUE);
}

void initSDL()
{
    int videoFlags;
    const SDL_VideoInfo *videoInfo;

    if(SDL_Init( SDL_INIT_VIDEO | SDL_INIT_AUDIO ) < 0)
    {
        fprintf( stderr, "Video initialization failed: %s\n", SDL_GetError());
	exit(-1);
    }

    videoInfo = SDL_GetVideoInfo( );
    if(!videoInfo)
    {
        fprintf(stderr, "Video query failed: %s\n",  SDL_GetError());
        exit(-1);
    }

    videoFlags  = SDL_OPENGL;          /* Enable OpenGL in SDL */
    videoFlags |= SDL_GL_DOUBLEBUFFER; /* Enable double buffering */

    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, videoFlags);
    if (!screen)
    {
        fprintf(stderr, "Video mode set failed: %s\n", SDL_GetError());
        exit(-1);
    }

    Mix_OpenAudio(44100, AUDIO_S16SYS, 2, 2048);

    SDL_WM_SetCaption( "Dragon Memory", "Dragon Memory");
    SDL_WM_SetIcon(IMG_Load(DATADIR "/gfx/icon.p"), NULL);
}
