void clearScreen(GLclampf r, GLclampf g, GLclampf b, GLclampf alpha)
{
    glClearColor(r, g, b, alpha);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

static int
power_of_2(int input)
{
    int value = 1;

    while (value < input) {
        value <<= 1;
    }
    return value;
}

CtextureData loadTexture(const char *file)
{
    CtextureData texture;
    GLuint textureId;
    GLenum textureFormat;
    SDL_Surface *surface;
    surface = IMG_Load(file);
    if(!surface)
    {
	    fprintf(stderr, "Error loading file %s", file);
	    exit(-1);
    }
    SDL_PixelFormat *format = surface->format;

    if(format->Amask)
	textureFormat = GL_RGBA;
    else 
    	textureFormat = GL_RGB;

    glGenTextures(1, &textureId);
    glBindTexture(GL_TEXTURE_2D, textureId);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glPixelStorei(GL_PACK_ALIGNMENT, 1);

    glTexImage2D( GL_TEXTURE_2D, 0, textureFormat, power_of_2(surface->w), power_of_2(surface->h), 0, textureFormat, GL_UNSIGNED_BYTE, NULL );
    glTexSubImage2D( GL_TEXTURE_2D, 0, 0, 0, surface->w, surface->h, textureFormat, GL_UNSIGNED_BYTE, surface->pixels );

    texture.id = textureId;
    texture.w = surface->w;
    texture.h = surface->h;
    texture.p2w = (float)surface->w / (float)power_of_2(surface->w);
    texture.p2h = (float)surface->h / (float)power_of_2(surface->h);

    SDL_FreeSurface(surface);
    return(texture);
}

void renderQuad(Cquad quad)
{
    // position
    glTranslatef(quad.x, quad.y, 0);
/* Start Transformations */
    glTranslatef((float)quad.w / 2, (float)quad.h / 2, 0);
	// rotation
    glRotatef(quad.angleX, 1.0f, 0.0f, 0.0f);
    glRotatef(quad.angleY, 0.0f, 1.0f, 0.0f);
    glRotatef(quad.angleZ, 0.0f, 0.0f, 1.0f);
	// scale
    glScalef(quad.scaleX, quad.scaleY, quad.scaleZ);

    glTranslatef((float)-1 * quad.w / 2, (float)-1 *quad.h / 2, 0);
/* End Transformations */

    glDisable(GL_TEXTURE_2D);
    glColor4f(quad.R, quad.G, quad.B, quad.A);

    glEnableClientState(GL_VERTEX_ARRAY);
    GLfloat vertices[] = { 0.0f, 0.0f, 0.0f,  quad.w, 0.0f, 0.0f,
                           quad.w, quad.h, 0.0f,  0.0f, quad.h, 0.0f };
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
    glDisableClientState(GL_VERTEX_ARRAY);

    glColor4f(1, 1, 1, 1);
    glLoadIdentity();
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
}

void renderSprite(Csprite sprite, bool androidUseQuads = false)
{
#ifndef ANDROID
    androidUseQuads = true;
#endif

    glEnable(GL_TEXTURE_2D);
    // position
    glTranslatef(sprite.x, sprite.y, sprite.z);
    glBindTexture(GL_TEXTURE_2D, sprite.texture.id);

/* Start Transformations */
    glTranslatef((float)sprite.w / 2, (float)sprite.h / 2, 0);
	// rotation
    glRotatef(sprite.angleX, 1.0f, 0.0f, 0.0f);
    glRotatef(sprite.angleY, 0.0f, 1.0f, 0.0f);
    glRotatef(sprite.angleZ, 0.0f, 0.0f, 1.0f);
	// scale
    glScalef(sprite.scaleX, sprite.scaleY, sprite.scaleZ);

    glTranslatef((float)-1 * sprite.w / 2, (float)-1 *sprite.h / 2, 0);
/* End Transformations */


    // calculate mapping vertexes
    float minX = (float)sprite.srcX / (float)sprite.texture.w * sprite.texture.p2w;
    float maxX = ((float)sprite.srcX + (float)sprite.w) / (float)sprite.texture.w * sprite.texture.p2w;
    float minY = (float)sprite.srcY / (float)sprite.texture.h * sprite.texture.p2h;
    float maxY = ((float)sprite.srcY + (float)sprite.h) / (float)sprite.texture.h * sprite.texture.p2h;

    float tmp;
    if(sprite.flipX)
    {
	tmp = minX;
	minX = maxX;
	maxX = tmp;
    }
    if(sprite.flipY)
    {
	tmp = minY;
	minY = maxY;
	maxY = tmp;
    }


#ifdef ANDROID
    if(!androidUseQuads)
    {
	int rect[4] = {sprite.srcX, sprite.srcY + sprite.h, sprite.w, -sprite.h};
	glTexParameteriv(GL_TEXTURE_2D, GL_TEXTURE_CROP_RECT_OES, rect);
	float spriteX = sprite.x;
	float spriteY = SCREEN_HEIGHT - sprite.y - sprite.h;
	float spriteW = sprite.w * sprite.scaleX;
	float spriteH = sprite.h * sprite.scaleY;
	spriteX = spriteX + (sprite.w / 2 - spriteW / 2);
	spriteY = spriteY + (sprite.h / 2 - spriteH / 2);
	glDrawTexiOES(spriteX, spriteY, 0, spriteW, spriteH);
    }
#endif
    if(androidUseQuads)
    {
	glEnableClientState(GL_VERTEX_ARRAY);
        glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        GLfloat vertices[] = { 0.0f, 0.0f, 0.0f,  sprite.w, 0.0f, 0.0f,
                               sprite.w, sprite.h, 0.0f,  0.0f, sprite.h, 0.0f };
        GLfloat texcoords[] = { minX, minY,  maxX, minY,  maxX, maxY,  minX, maxY };
        glVertexPointer(3, GL_FLOAT, 0, vertices);
        glTexCoordPointer(2, GL_FLOAT, 0, texcoords);
        glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
        glDisableClientState(GL_TEXTURE_COORD_ARRAY);
        glDisableClientState(GL_VERTEX_ARRAY);
    }

    glLoadIdentity();
}
