#define CLICKPAUSE 300
#define CLICKRETRYLEVEL  301
#define CLICKNEXTLEVEL   302
void drawTiles()
{
    int x, y;
    if(Stiles.scaleX < 1)
    {
	Stiles.scaleX += 2 * loopTime;
	Stiles.scaleY += 2 * loopTime;
    }
    else
    {
	Stiles.scaleX = 1.0;
	Stiles.scaleY = 1.0;
    }			

    for(y = 0; y < mlevel[levelNumber].tilesV; y++)
    {
	for(x  = 0; x < mlevel[levelNumber].tilesH; x++)
	{
	    if(mtile[x][y].x + TILEW > mcamera.x && mtile[x][y].x < mcamera.x + mcamera.w)
		if(mtile[x][y].y > mcamera.y && mtile[x][y].y < mcamera.y + mcamera.w)
		{
            	    Stiles.x = mtile[x][y].x - mcamera.x;
            	    Stiles.y = mtile[x][y].y - mcamera.y;
    		    Stiles.srcY = 0;
    		    Stiles.srcX = 0;

		    // check for not drawing off screen area
            	    if(mtile[x][y].x < mcamera.x)
            	    {
            		Stiles.srcX = mcamera.x - mtile[x][y].x;
            		Stiles.w = TILEW - Stiles.srcX;
            		Stiles.x = 0;
            	    }
            	    else if(mtile[x][y].x + TILEW > (mcamera.x + mcamera.w) && mtile[x][y].x + TILEW < mcamera.x + mcamera.w + TILEW)
            		Stiles.w = (mcamera.x + mcamera.w) - mtile[x][y].x;
            	    else
			Stiles.w = TILEW;

		    if(mtile[x][y].visible || mtile[x][y].matched)
		    {
			Stiles.srcY += int(mtile[x][y].id / TILESHEETCOLS) * TILEH;
			Stiles.srcX += (mtile[x][y].id  - int(mtile[x][y].id / TILESHEETCOLS) * TILESHEETCOLS) * TILEW;
		    }
		    renderSprite(Stiles);
		}
	}
    }
}

void drawBackground()
{
    if(SgameBackground.scaleX > 1)
    {
	SgameBackground.scaleX -= 2 * loopTime;
	SgameBackground.scaleY -= 2 * loopTime;
    }
    else
    {
	SgameBackground.scaleX = 1;
	SgameBackground.scaleY = 1;
    }
    
    SgameBackground.w = mcamera.w;
    SgameBackground.h = SCREEN_HEIGHT;

    if(mlevel[levelNumber].screenW > SCREEN_WIDTH)
	SgameBackground.srcX = (mcamera.x * (SgameBackground.texture.w - mcamera.w)) / (mlevel[levelNumber].screenW - mcamera.w);
    else
	SgameBackground.srcX = (SgameBackground.texture.w - SCREEN_WIDTH) / 2;

    renderSprite(SgameBackground);
}


void moveCamera()
{
    if(mlevel[levelNumber].screenW > SCREEN_WIDTH)
    {
	float slideMoves;
        slideMoves = ((float)mlevel[levelNumber].screenW - (float)mcamera.w) / ((float)SslideBar.w - (float)Sslider.w);
        mcamera.x = ((Sslider.x - SslideBar.x) * slideMoves);
    }
}

void showVolumeStatus()
{
    if(volumeOSDTime > 0)
    {
	Svolume.srcX = 0;
	Svolume.srcY = overallVolume * Svolume.h;
	Svolume.x = (SCREEN_WIDTH - Svolume.w) /2;
	Svolume.y = 20;
	volumeOSDTime -= loopTime;
	if(volumeOSDTime < 0)
	    volumeOSDTime = 0;
	renderSprite(Svolume);
    }
}

void drawStatusBar()
{
/* draw level title and hint */
    SgameFont.x = 100;
    SgameFont.y = SslideBar.y - ((SgameFont.w * 3)+ 4);
    dtPrint(SgameFont, mlevel[levelNumber].name);

    SgameFont.y += SgameFont.h + 2;
    dtPrint(SgameFont, mlevel[levelNumber].hint);

    SgameFont.x = SCREEN_WIDTH - 14 * (SgameFont.w);
    SgameFont.y = SslideBar.y - ((SgameFont.h * 3)+ 4);
    dtPrint(SgameFont, "SCORE: %d", mlevel[levelNumber].playerScore);

    SgameFont.y += SgameFont.h + 2;
    dtPrint(SgameFont, " TIME: %d", int(mlevel[levelNumber].time - mlevel[levelNumber].playerTime));

//    SgameFont.y += SgameFont.h + 2;
//    dtPrint(SgameFont, " FPS: %d", int(framesPerSecond()));

/* draw SlideBar and Slider */
    if(mlevel[levelNumber].hasSlideBar)
    {
	renderSprite(SslideBar);
	// Show slider
	Sslider.y = SslideBar.y + (SslideBar.h - Sslider.h) / 2;
        renderSprite(Sslider);
    }
}

void drawPauseButton()
{
    SpauseButton.x = PAUSEBUTTON_X;
    SpauseButton.y = PAUSEBUTTON_Y;
    renderSprite(SpauseButton);
}

void drawScreen()
{
    moveCamera();
    drawBackground();
    drawTiles();
    drawStatusBar();
    drawPauseButton();
    showVolumeStatus();
}


void setMatched(int id)
{
    int x, y;
    for(y = 0; y < mlevel[levelNumber].tilesV; y++)
	for(x = 0; x < mlevel[levelNumber].tilesH; x++)
	    if(mtile[x][y].id == id)
		mtile[x][y].matched = true;
}

void wait(int milisecs) // wait (keep playing music & stuff)
{
    playMusic();
    SDL_Event event; // Flush pending events
    while(SDL_PollEvent(&event)) {}
    SDL_Delay(milisecs);
}

void playCombo(int comboCounter)
{
	char line1[25];
	char line2[15];
	if(comboCounter == 1) sprintf(line1, "WHAT A NICE");
	if(comboCounter == 2) sprintf(line1, "THAT IS A GREAT");
	if(comboCounter == 3) sprintf(line1, "IMPRESSIVE");
	if(comboCounter == 4) sprintf(line1, "OUTSTANDING");
	if(comboCounter == 5) sprintf(line1, "I CANNOT BELIEVE IT!");
	if(comboCounter == 6) sprintf(line1, "SUPERNATURAL");
	if(comboCounter >= 7) sprintf(line1, "YOU MADE AN EPIC"); 
	sprintf(line2, "%dX COMBO!", comboCounter + 1);

	SoptionsMenuFont.x = (SCREEN_WIDTH / 2) - (strlen(line1) * SoptionsMenuFont.w) / 2;
	SoptionsMenuFont.y = (SCREEN_HEIGHT / 2) - ((SoptionsMenuFont.h) * 2) / 2;
	dtPrint(SoptionsMenuFont, line1);

	SoptionsMenuFont.x = (SCREEN_WIDTH / 2) - (strlen(line2) * SoptionsMenuFont.w) / 2;
	SoptionsMenuFont.y += SoptionsMenuFont.h;
	dtPrint(SoptionsMenuFont, line2);
	comboFx();
}

void showScoreInfo()
{
    char title[22];
    char line[12][26];
    char score[12][10];
    
    int totalLevelScore;
    int n;
    overallScore = 0;
    overallTime = 0;
    totalLevelScore = mlevel[levelNumber].playerScore + (int(mlevel[levelNumber].time - mlevel[levelNumber].playerTime) * 10) + mlevel[levelNumber].comboScore;

    int minutes, seconds;

// Draw the background 
    drawBackground();

    SscoreInfo.x = 159;
    SscoreInfo.y = 57;
    renderSprite(SscoreInfo);

    sprintf(title, "LEVEL %d COMPLETED", levelNumber);
    SoptionsMenuFont.x = (SCREEN_WIDTH / 2) - (strlen(title) * SoptionsMenuFont.w) / 2;
    SoptionsMenuFont.y = 30;
    dtPrint(SoptionsMenuFont, title);

    sprintf(line[1], "SCORE");
    sprintf(line[2], "LEVEL TIME");
    sprintf(line[3], "TIME BONUS");
    sprintf(line[4], "COMBOS MADE");
    sprintf(line[5], "COMBO BONUS");
    sprintf(line[6], "TOTAL SCORE");
    sprintf(line[7], "LEVEL TOP SCORE");
    sprintf(line[8], "LEVEL TOP TIME");
    sprintf(line[9], " ");

    sprintf(score[1], "%d", mlevel[levelNumber].playerScore);

    minutes = int(mlevel[levelNumber].playerTime / 60);
    seconds = mlevel[levelNumber].playerTime - minutes * 60;
    if(seconds < 10) sprintf(score[2], "%d:0%d", minutes, seconds);
    else sprintf(score[2], "%d:%d", minutes, seconds);

    sprintf(score[3], "%d", int(mlevel[levelNumber].time - mlevel[levelNumber].playerTime) * 10);
    sprintf(score[4], "%d", mlevel[levelNumber].combos);
    sprintf(score[5], "%d", mlevel[levelNumber].comboScore);
    sprintf(score[6], "%d", totalLevelScore);
    sprintf(score[7], "%d", mlevel[levelNumber].hiScore);

    minutes = int(mlevel[levelNumber].hiTime / 60);
    seconds = mlevel[levelNumber].hiTime - minutes * 60;
    if(seconds < 10) sprintf(score[8], "%d:0%d", minutes, seconds);
    else sprintf(score[8], "%d:%d", minutes, seconds);

    sprintf(score[9] , " ");
    sprintf(score[10] , " ");

    if(totalLevelScore > mlevel[levelNumber].hiScore)
	sprintf(line[9], "TOP SCORE AWARD!");
    if(mlevel[levelNumber].playerTime < mlevel[levelNumber].hiTime)
	sprintf(line[9], "BEST TIME AWARD!");
    if(mlevel[levelNumber].playerTime < mlevel[levelNumber].hiTime && totalLevelScore > mlevel[levelNumber].hiScore)
	sprintf(line[9], "TOP SCORE AND TIME AWARD!");

    
    for(n = 1; n <= levelNumber; n++)
    {
	overallScore += mlevel[n].playerScore + (int(mlevel[n].time - mlevel[n].playerTime) * 10) + mlevel[n].comboScore;;
	overallTime += mlevel[n].playerTime;
    }
    sprintf(line[10], "OVERALL SCORE");
    sprintf(line[11], "OVERALL TIME");
    sprintf(score[10], "%d", overallScore);

    minutes = overallTime / 60;
    seconds = overallTime - minutes * 60;
    if(seconds < 10) sprintf(score[11], "%d:0%d", minutes, seconds);
    else sprintf(score[11], "%d:%d", minutes, seconds);

    SgameFont.y = 100;
    for(n = 1; n<= 11; n++) // 11 is the number of lines to display
    {
        SgameFont.x = 200;
	dtPrint(SgameFont, line[n]);
	SgameFont.x += SscoreInfo.w - 80 - strlen(score[n]) * SgameFont.w;
	dtPrint(SgameFont, score[n]);
	SgameFont.y += 30;
    }
// START MEDAL CHECK //
    int medalScore = 0;
    if(levelNumber == 1) medalScore = 1;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.9))
	medalScore++;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.8))
	medalScore++;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.7))
	medalScore++;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.6))
	medalScore++;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.5))
	medalScore++;
    if(mlevel[levelNumber].playerTime <= int(mlevel[levelNumber].time * 0.4))
	medalScore++;

    if(mlevel[levelNumber].combos > int(ceil(mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV / mlevel[levelNumber].match) * 0.10)) // 10% combos
	medalScore++;
    if(mlevel[levelNumber].combos > int(ceil(mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV / mlevel[levelNumber].match) * 0.20)) // 20% combos
	medalScore++;
    if(mlevel[levelNumber].combos > int(ceil(mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV / mlevel[levelNumber].match) * 0.25)) // 25% combos
	medalScore++;
    if(mlevel[levelNumber].combos > int(ceil(mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV / mlevel[levelNumber].match) * 0.50)) // 50% combos
	medalScore++;

    if(medalScore > 3) mlevel[levelNumber].medal = 1; // bronze medal
    if(medalScore > 5) mlevel[levelNumber].medal = 2; // silver medal
    if(medalScore > 8) mlevel[levelNumber].medal = 3; // gold medal
// END MEDAL CHECK //
    saveScore(totalLevelScore, mlevel[levelNumber].playerTime);
// START -RETRY - CONTINUE- BUTTONS //

    Smedals.srcX = (mlevel[levelNumber].medal - 1) * Smedals.w;

    int retryButton_x = 11;
    int retryButton_y = 406;
    int continueButton_x = 627;
    int continueButton_y = 406;

    SadvanceButtons.x = retryButton_x;
    SadvanceButtons.y = retryButton_y;
    renderSprite(SadvanceButtons);

    SadvanceButtons.srcX = SadvanceButtons.w;
    SadvanceButtons.x = continueButton_x;
    SadvanceButtons.y = continueButton_y;
    renderSprite(SadvanceButtons);

    if(mlevel[levelNumber].medal > 0)
    {
	Smedals.x = 580;
        Smedals.y = 377;
	renderSprite(Smedals);
    }
    SDL_GL_SwapBuffers();

    SDL_Event(event);
    int mouseX, mouseY;
    while(true)
    {
	SDL_GetMouseState(&mouseX, &mouseY);
	SDL_PollEvent(&event);
	if(event.type == SDL_MOUSEBUTTONDOWN)
	{
	    if(mouseY > retryButton_y && mouseY < retryButton_y + SadvanceButtons.h)
	    {
		if(mouseX > retryButton_x && mouseX < retryButton_x + SadvanceButtons.w)
		{
		    levelNumber--;
		    break;
		}
		if(mouseX > continueButton_x && mouseX < continueButton_x + SadvanceButtons.w)
		    break;
	    }
	}
	SDL_Delay(0);
    }
// END -RETRY - CONTINUE- BUTTONS //
}

int gameEvents()
{
    SDL_Event event;
    int clickId = 0;

    while(SDL_PollEvent(&event))
    {
	SDL_GetMouseState(&mouseX, &mouseY);

/* Check keys */
	if(event.type == SDL_KEYDOWN)
	{
	    if(event.key.keysym.sym == SDLK_ESCAPE)
		clickId = ENDGAME;
	    if(event.key.keysym.sym == KEYVOLUMEDOWN)
	    {
		volumeOSDTime = VOLUMEOSDTIME;
		overallVolume--;
	    }
	    if(event.key.keysym.sym == KEYVOLUMEUP)
	    {
		volumeOSDTime = VOLUMEOSDTIME;
		overallVolume++;
	    }
	}
#ifdef ANDROID
/* Phone external events */
	    if(event.type == SDL_ACTIVEEVENT && event.active.gain == 0 && event.active.state & SDL_APPACTIVE )
	    {
		// We've lost GL context, we are not allowed to do any GFX output here, or app will crash!
		while(true)
		{
        	    SDL_PollEvent(&event);
        	    if(event.type == SDL_ACTIVEEVENT && event.active.gain && event.active.state & SDL_APPACTIVE )
        	    {
//		    	initSDL();
//			initGL();
//			deleteTextures();
//			loadLevelData();
//			SDL_GL_SwapBuffers();
	    	    SDL_Flip(SDL_GetVideoSurface()); // One SDL_Flip() call is required here to restore OpenGL context
            		// Re-load all textures, matrixes and all other GL states if we're in SDL+OpenGL mode
            		// Re-load all images to SDL_Texture if we're using it
            		// Now we can draw
//			flushEvents();
            		break;
    		    }
            	    SDL_Delay(300);
		}
	    }
#endif

	if(event.type == SDL_MOUSEBUTTONDOWN)
	{
/* Check for slidebar */
		if(mlevel[levelNumber].hasSlideBar && mouseX >= SslideBar.x && mouseX <= SslideBar.x + SslideBar.w && mouseY >= SslideBar.y && mouseY <= SslideBar.y + SslideBar.h)
		sliderIsActive = true;
	    else 
		sliderIsActive = false;

/* Check for pause */
		if(mouseX >= PAUSEBUTTON_X && mouseX <= PAUSEBUTTON_X + SpauseButton.w)
	    	if(mouseY >= PAUSEBUTTON_Y && mouseY <= PAUSEBUTTON_Y + SpauseButton.h)
				clickId = CLICKPAUSE;

/* Check for tiles */
        for(int y = 0; y < mlevel[levelNumber].tilesV; y++)
    	    for(int x = 0; x < mlevel[levelNumber].tilesH; x++)
	    {
	        if(mouseX + mcamera.x >= (mtile[x][y].x) && mouseX + mcamera.x <= (mtile[x][y].x + TILEW))
	    	    if(mouseY + mcamera.y > (mtile[x][y].y) && mouseY +mcamera.y < (mtile[x][y].y + TILEH))
		        if(!mtile[x][y].visible && !mtile[x][y].matched)
		        {
		    	    mtile[x][y].visible = true;
			    Mix_PlayChannel(-1, touchSound, 0);
			    clickId = mtile[x][y].id;
			}
	    }
    }
    else if(event.type == SDL_MOUSEBUTTONUP)
	sliderIsActive = false;
    }
    return(clickId);
}

void initTiles()
{
    Stiles.scaleX = 0.0;
    Stiles.scaleY = 0.0;
    int n, m, id, randomNum;
    int chipsCount; // number of unique chips
    int allTiles[mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV];
    chipsCount = (mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV) / mlevel[levelNumber].match;

    for(n = 0; n < mlevel[levelNumber].match; n++)
    {
	id = 1;
	for(m = 0; m < chipsCount; m++)
	{
	    allTiles[m + (n * chipsCount)] = id;
	    id++;
	}
     }

    // shuffle the chips
    srand(time(NULL));
    for(n = 0; n < (mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV); n++)
    {
	randomNum = rand() %(mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV);
	m = allTiles[randomNum];
	allTiles[randomNum] = allTiles[n];
	allTiles[n] = m;
    }

    for(m = 0; m < mlevel[levelNumber].tilesV; m++)
	for(n = 0; n < mlevel[levelNumber].tilesH; n++)
	    mtile[n][m].id = allTiles[(m * mlevel[levelNumber].tilesH) + n];
}
                        
bool checkForMatch(int id)
{
    int matches = 0;
    int x, y;
    bool match = false;
    for(y = 0; y < mlevel[levelNumber].tilesV; y++)
	for(x = 0; x < mlevel[levelNumber].tilesH; x++)
	    if(mtile[x][y].id == id && mtile[x][y].visible && !mtile[x][y].matched)
		matches++;

    if(matches == mlevel[levelNumber].match)
        for(y = 0; y < mlevel[levelNumber].tilesV; y++)
    	    for(x = 0; x < mlevel[levelNumber].tilesH; x++)
	    {
		if(mtile[x][y].id == id)
		{
	    	    mtile[x][y].matched = true;
	    	    match = true;
	    	}
	    }
    else
        for(y = 0; y < mlevel[levelNumber].tilesV; y++)
    	    for(x = 0; x < mlevel[levelNumber].tilesH; x++)
	        mtile[x][y].visible = false;
    return(match);
}

void pauseGame()
{
    char text[30];
    flushEvents();
    SDL_Event event;
    initComboFx(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    while(true)
    {
	SDL_GetMouseState(&mouseX, &mouseY);
	SDL_PollEvent(&event);
	if(event.type == SDL_KEYDOWN)
	    if(event.key.keysym.sym == SDLK_ESCAPE)
		break;
	if(event.type == SDL_MOUSEBUTTONDOWN)
	    if(mouseX >= PAUSEBUTTON_X && mouseX <= PAUSEBUTTON_X + SpauseButton.w && mouseY >= PAUSEBUTTON_Y && mouseY <= PAUSEBUTTON_Y + SpauseButton.h)
		    break;

	clearScreen(0, 0, 0, 1);
	comboFx();
	sprintf(text, "GAME PAUSED");
	SoptionsMenuFont.y = (SCREEN_HEIGHT - SoptionsMenuFont.h) / 2 - SoptionsMenuFont.h * 3;
	SoptionsMenuFont.x = (SCREEN_WIDTH - strlen(text) * SoptionsMenuFont.w) / 2;
	dtPrint(SoptionsMenuFont, text);
#ifndef ANDROID
	sprintf(text, "Basic ingame controls");
	SoptionsMenuFont.y += SoptionsMenuFont.h * 3;
	SoptionsMenuFont.x = (SCREEN_WIDTH - strlen(text) * SoptionsMenuFont.w) / 2;
	dtPrint(SoptionsMenuFont, text);

	sprintf(text, "Right [+]/[-] adjust Volume");
	SoptionsMenuFont.y += SoptionsMenuFont.h * 3;
	SoptionsMenuFont.x = (SCREEN_WIDTH - strlen(text) * SoptionsMenuFont.w) / 2;
	dtPrint(SoptionsMenuFont, text);

	sprintf(text, "ESC to exit game");
	SoptionsMenuFont.y += SoptionsMenuFont.h * 2;
	SoptionsMenuFont.x = (SCREEN_WIDTH - strlen(text) * SoptionsMenuFont.w) / 2;
	dtPrint(SoptionsMenuFont, text);
#endif
	drawPauseButton();
	SDL_GL_SwapBuffers();
	timing();
	SDL_Delay(5); 
    }
    timing();
}

int doGame()
{
    setLevel();
    initTiles();
    if(mlevel[levelNumber].screenW > SCREEN_WIDTH)
	mlevel[levelNumber].hasSlideBar = true;

// --- START GAME INIT --- //
    int playGame = 0;
    int testMatch; // variable to check if the level is completed.
    bool allMatched = false;
    int clickId;
    int gameTurn = 1;
    int n, m;

    SslideBar.x = (SCREEN_WIDTH - SslideBar.w) / 2;
    SslideBar.y = (SCREEN_HEIGHT - SslideBar.h) - 6;
    Sslider.x = SslideBar.x;

    SgameBackground.scaleX = 2;
    SgameBackground.scaleY = 2;

    comboCounter = -1;
    float comboTime;
    bool isCombo = false;
    
    lastFrame = SDL_GetTicks();
// --- END GAME INIT --- //

// --- START GAME LOOP --- //
    while(playGame != EXITGAME && playGame != ENDGAME && playGame != LEVELCOMPLETE)
    {
	clickId = gameEvents();

	if(clickId == CLICKPAUSE)
	    pauseGame();
        drawScreen();

	if(isCombo)
	{
	    if(comboTime > 0)
	    {
		playCombo(comboCounter);
		comboTime-= loopTime;
	    }
	    else
	    {
		isCombo = false;
		if(allMatched)
		    clickId = LEVELCOMPLETE;
	    }
	}

    SDL_GL_SwapBuffers();

	if(sliderIsActive) /* Move the Slider */
        {
	    Sslider.x = mouseX - Sslider.w / 2;
	    if(Sslider.x < SslideBar.x)
		Sslider.x = SslideBar.x;
	    if(Sslider.x > SslideBar.x + SslideBar.w - Sslider.w)
		Sslider.x = SslideBar.x + SslideBar.w - Sslider.w;
	}

	if(clickId > 0 && !sliderIsActive) /* Something is clicked */
	{
	    if(clickId <= MAXTILES) /* a tile has been clicked */
	    {
		if(gameTurn == mlevel[levelNumber].match) /* Last turn */
		{
		    gameTurn = 1;
		    if(checkForMatch(clickId)) /* there is a match */
		    {
		        mlevel[levelNumber].playerScore += 10 * levelNumber;
			Mix_PlayChannel(-1, matchSound, 0);
		        comboCounter++;
			/* Check if all tiles of the level has been matched */
			testMatch = 0;
			for(m = 0; m < mlevel[levelNumber].tilesV; m++)
			    for(n = 0; n < mlevel[levelNumber].tilesH; n++)
			        if(mtile[n][m].matched)
				    testMatch+=1;
		    	    if(testMatch == mlevel[levelNumber].tilesH * mlevel[levelNumber].tilesV)
				allMatched = true;
		    }
		    else
		    {
			comboCounter = -1;
			Mix_PlayChannel(-1, noMatchSound, 0);
			wait(mlevel[levelNumber].waitTime);
			flushEvents();
    			/* Turn down the unmatched tiles */
			for(m = 0; m < mlevel[levelNumber].tilesV; m++)
			    for(n = 0; n < mlevel[levelNumber].tilesH; n++)
	    			if(!mtile[n][m].matched)
	    			    mtile[n][m].visible = false;
		    }
	    	    if(comboCounter > 0)
		    {
			comboTime = COMBO_DURATION;
			isCombo = true;
			initComboFx(SCREEN_WIDTH/2 - 200, SCREEN_HEIGHT/2 - 50, 400, 100);
		        Mix_PlayChannel(-1, comboSound, 0);
    	    	        mlevel[levelNumber].comboScore += (levelNumber * comboCounter * 10);
		        mlevel[levelNumber].combos++;
		        SgameBackground.scaleX = 1.25;
		        SgameBackground.scaleY = 1.25;
		    }
		}
		else
		    gameTurn++;
	    }
	}
	playGame = clickId;

	playMusic();
	SDL_Delay(2);
	timing();
	mlevel[levelNumber].playerTime += loopTime;
    }
    stopMusic();
    return(playGame);
}
