#define PARTICLES 512
#define particle_accel 20
#define particle_max_speed 260
#define COMBO_DURATION 2
struct Cparticle
{
    Cquad quad;
    float speed_x, speed_y;
    float speedAngleX, speedAngleY, speedAngleZ;
    float speedScaleX, speedScaleY, speedScaleZ;
};
Cparticle mparticle[PARTICLES];


void initComboFx(int x, int y, int w, int h)
{
    int n;
    for(n=0; n<PARTICLES; n++)
    {
	mparticle[n].speed_x = rand()%(particle_max_speed*2)-particle_max_speed;
	mparticle[n].speed_y = rand()%particle_max_speed-particle_max_speed;
	mparticle[n].quad.x  = rand()%w+x;
	mparticle[n].quad.y  = rand()%h+y;
	mparticle[n].quad.w  = rand()%10+1;
	mparticle[n].quad.h  = rand()%10+1;
	mparticle[n].quad.R  = rand()%100;
	mparticle[n].quad.G  = rand()%100;
	mparticle[n].quad.B  = rand()%100;
	mparticle[n].quad.A  = rand()%100;

	mparticle[n].quad.R /= 100;
	mparticle[n].quad.G /= 100;
	mparticle[n].quad.B /= 100;
	mparticle[n].quad.A /= 100;
	
	mparticle[n].speedAngleX = rand()%20 - 10;
	mparticle[n].speedAngleY = rand()%20 - 10;
	mparticle[n].speedAngleZ = rand()%20 - 10;
    }
}

void comboFx()
{
    int n;
    for(n=0; n<PARTICLES; n++)
    {
	if(mparticle[n].speed_x>0) mparticle[n].speed_x -= particle_accel * loopTime;
	else mparticle[n].speed_x += particle_accel * loopTime;
	mparticle[n].speed_y += particle_accel * loopTime;
	if(mparticle[n].speed_x > 0 && mparticle[n].speed_x >= particle_max_speed) mparticle[n].speed_x= particle_max_speed;
	if(mparticle[n].speed_x < 0 && mparticle[n].speed_x <= -particle_max_speed) mparticle[n].speed_x= -particle_max_speed;
	if(mparticle[n].speed_y>=particle_max_speed) mparticle[n].speed_y=particle_max_speed;
	mparticle[n].quad.x+=mparticle[n].speed_x*loopTime;
	mparticle[n].quad.y+=mparticle[n].speed_y*loopTime;
	if(mparticle[n].quad.x > SCREEN_WIDTH) mparticle[n].quad.x = 0;
	if(mparticle[n].quad.y > SCREEN_HEIGHT) mparticle[n].quad.y = 0;
	if(mparticle[n].quad.x < 0) mparticle[n].quad.x = SCREEN_WIDTH;
	if(mparticle[n].quad.y < 0) mparticle[n].quad.y = SCREEN_HEIGHT;

	renderQuad(mparticle[n].quad);

// rotacion y escalado de confetti :)
	mparticle[n].quad.angleX += mparticle[n].speedAngleX;
	if(mparticle[n].quad.angleX > 360) mparticle[n].quad.angleX -= 360;
	mparticle[n].quad.angleY += mparticle[n].speedAngleY;
	if(mparticle[n].quad.angleY > 360) mparticle[n].quad.angleY -= 360;
	mparticle[n].quad.angleZ += mparticle[n].speedAngleZ;
	if(mparticle[n].quad.angleZ > 360) mparticle[n].quad.angleZ -= 360;

	mparticle[n].quad.scaleX = 1;
	mparticle[n].quad.scaleY = 1;
	mparticle[n].quad.scaleZ = 1;
    }
}
