void loadScores()
{
    int hiByte, loByte;
    FILE *scores;
    scores = fopen(SAVEDIR "/hiscore.dat", "rb");
    if(scores == NULL)
    {
		scores = fopen(SAVEDIR "/hiscore.dat", "wb+");
		fputc(1 ,scores);
		fputc(0, scores);
		fputc(0 ,scores);
		fputc(200, scores);
		fputc(0 ,scores);
		fputc(0 ,scores);
		fclose(scores);
		scores = fopen(SAVEDIR "/hiscore.dat", "rb");
    }
    maxLevel = fgetc(scores);
    if(maxLevel == EOF)
	maxLevel = 1;

    if(levelNumber > MAXLEVELS) 
	levelNumber = MAXLEVELS;

    int n;
    for(n = 1; n <= MAXLEVELS; n++)
    {
	hiByte = fgetc(scores);
	loByte = fgetc(scores);
	if(hiByte == EOF || loByte == EOF) { hiByte = 0; loByte = 0;}
	mlevel[n].hiScore = hiByte * 255 + loByte;

	hiByte = fgetc(scores);
	loByte = fgetc(scores);
	if(hiByte == EOF || loByte == EOF) { hiByte = 200; loByte = 0;}
	mlevel[n].hiTime = hiByte * 255 + loByte;
	
	mlevel[n].medal = fgetc(scores);
    }
    fclose(scores);
}

void saveScore(int score, int time)
{
// scores file is an array of TOTALLEVELS elemens consisting of 5 bytes
// 2 used for the score and 2 for the time. The last one is for medals.
// 1 extra byte at the BEGINING of the file to store the last unlocked level
    int maxSavedLevel, hiByte, loByte;
    FILE *scores;
    scores = fopen(SAVEDIR "/hiscore.dat", "rb+");

    maxSavedLevel = fgetc(scores);
    if(levelNumber + 1 > maxSavedLevel)
    {
	fseek(scores, 0, SEEK_SET);
	fputc(levelNumber + 1, scores); // store the last level unlocked
    }    

    fseek(scores, 5 * (levelNumber-1), SEEK_CUR); // jump to the current level score

    hiByte = score / 255;
    loByte = score - hiByte * 255;
    fputc(hiByte, scores);
    fputc(loByte, scores);
    if(mlevel[levelNumber].playerTime < mlevel[levelNumber].hiTime)
    {
        hiByte = int(mlevel[levelNumber].playerTime / 255);
        loByte = int(mlevel[levelNumber].playerTime - hiByte * 255);
        fputc(hiByte, scores);
        fputc(loByte, scores);
    }
    fputc(mlevel[levelNumber].medal, scores);

    fclose(scores);
}

void loadLevelData()
{
    char fileName[60];

    SgameBackground = initSprite();
    sprintf(fileName, DATADIR "/themes/%d/background.p", mlevel[levelNumber].theme);
    SgameBackground.texture = loadTexture(fileName);
    SgameBackground.w = SgameBackground.texture.w;
    SgameBackground.h = SgameBackground.texture.h;

    Stiles = initSprite();
    sprintf(fileName, DATADIR "/themes/%d/tiles.p", mlevel[levelNumber].theme);
    Stiles.texture = loadTexture(fileName);
    Stiles.w = Stiles.texture.w / TILESHEETCOLS;
    Stiles.h = Stiles.texture.h / TILESHEETROWS;

    SslideBar = initSprite();
    sprintf(fileName, DATADIR "/themes/%d/slideBar.p", mlevel[levelNumber].theme);
    SslideBar.texture = loadTexture(fileName);
    SslideBar.w = SslideBar.texture.w;
    SslideBar.h = SslideBar.texture.h;

    Sslider = initSprite();
    sprintf(fileName, DATADIR "/themes/%d/slider.p", mlevel[levelNumber].theme);
    Sslider.texture = loadTexture(fileName);
    Sslider.w = Sslider.texture.w;
    Sslider.h = Sslider.texture.h;
    
    SscoreInfo = initSprite();
    sprintf(fileName, DATADIR "/gfx/scoreInfo.p");
    SscoreInfo.texture = loadTexture(fileName);
    SscoreInfo.w = SscoreInfo.texture.w;
    SscoreInfo.h = SscoreInfo.texture.w;

// Load ingame fonts
    SgameFont = initSprite();
    SgameFont.texture = loadTexture(DATADIR "/fonts/info.p");
    SgameFont.w = SgameFont.texture.w/FONTSHEETCOLS;
    SgameFont.h = SgameFont.texture.h/FONTSHEETROWS;

    SoptionsMenuFont = initSprite();
    SoptionsMenuFont.texture = loadTexture(DATADIR "/fonts/mainMenu.p");
    SoptionsMenuFont.w = SoptionsMenuFont.texture.w / FONTSHEETCOLS;
    SoptionsMenuFont.h = SoptionsMenuFont.texture.h / FONTSHEETROWS;

// Load options menu items
    SpauseButton = initSprite();
    SpauseButton.texture = loadTexture(DATADIR "/gfx/pauseButton.p");
    SpauseButton.w = SpauseButton.texture.w;
    SpauseButton.h = SpauseButton.texture.h;

    Svolume = initSprite();
    Svolume.texture = loadTexture(DATADIR "/gfx/volume.p");
    Svolume.w = Svolume.texture.w;
    Svolume.h = Svolume.texture.h / 11; // 11 is the volume level graphics (from 0 to 10)

    SadvanceButtons = initSprite();
    SadvanceButtons.texture = loadTexture(DATADIR "/gfx/advanceButtons.p");
    SadvanceButtons.w = SadvanceButtons.texture.w / 2; // hay 2 botones: continuar y reintentar
    SadvanceButtons.h = SadvanceButtons.texture.h;
    
    Smedals = initSprite();
    Smedals.texture = loadTexture(DATADIR "/gfx/medals.p");
    Smedals.w = Smedals.texture.w / 3; // hay 3 medallas (bronce, plata y oro)
    Smedals.h = Smedals.texture.h;

    music = Mix_LoadMUS(DATADIR "/music/gameMusic.s3m");
    touchSound = Mix_LoadWAV(DATADIR "/sounds/touch.wav");
    matchSound = Mix_LoadWAV(DATADIR "/sounds/match.wav");
    noMatchSound = Mix_LoadWAV(DATADIR "/sounds/nomatch.wav");
    comboSound = Mix_LoadWAV(DATADIR "/sounds/combo.wav");
}

void deleteTextures()
{
    glDeleteTextures(1, &SgameBackground.texture.id);
    glDeleteTextures(1, &Stiles.texture.id);
    glDeleteTextures(1, &SslideBar.texture.id);
    glDeleteTextures(1, &Sslider.texture.id);
    glDeleteTextures(1, &SscoreInfo.texture.id);
    glDeleteTextures(1, &SgameFont.texture.id);
    glDeleteTextures(1, &SoptionsMenuFont.texture.id);
    glDeleteTextures(1, &SpauseButton.texture.id);
    glDeleteTextures(1, &SoptionsMenu.texture.id);
    glDeleteTextures(1, &Svolume.texture.id);
    glDeleteTextures(1, &SvolumeButtons.texture.id);
    glDeleteTextures(1, &SadvanceButtons.texture.id);
    glDeleteTextures(1, &Smedals.texture.id);
}
