#define DATADIR "."
// Windows & Android
#define SAVEDIR "."

// Linux 
// #define SAVEDIR "/homedir/.config/package" (leer de argv[])
#define MAXLEVELS 15
#define MAXTILES 80
#define PLAYGAME 1
#define EXITGAME 99
#define LEVELCOMPLETE 97
#define ENDGAME 98

#define MAXFPS 60

// Keyboard definitions

#ifdef ANDROID
#define KEYVOLUMEDOWN SDLK_LCTRL
#define KEYVOLUMEUP   SDLK_RCTRL
#else
#define KEYVOLUMEDOWN SDLK_KP_MINUS
#define KEYVOLUMEUP   SDLK_KP_PLUS
#endif

struct CtextureData
{
    GLuint id;
    int w, h; // ancho y alto de la textura
    float p2w, p2h; // Stretch coefficients for non-power-of-2 textures
    const char *fileName;
};

struct Csprite
{
    CtextureData texture;
    int srcX, srcY; // offset del sprite en la textura
    int w, h; // ancho y alto del sprite
    float x, y, z; // posicion en pantalla
    float angleX, angleY, angleZ; // rotacion
    float scaleX, scaleY, scaleZ;
    bool flipX;
    bool flipY;
};

Csprite SgameBackground, Stiles, SslideBar, Sslider, SgameFont, SoptionsMenu, SmenuPlay, SmenuExit;
Csprite SpauseButton, SoptionsMenuFont, Svolume, SvolumeButtons, SscoreInfo;
Csprite SadvanceButtons, Smedals;

Csprite initSprite()
{
    Csprite sprite;
    sprite.srcX = 0;
    sprite.srcY = 0;
    sprite.w = 0;
    sprite.h = 0;
    sprite.x = 0.0;
    sprite.y = 0.0;
    sprite.z = 0.0;
    sprite.angleX = 0;
    sprite.angleY = 0;
    sprite.angleZ = 0;
    sprite.scaleX = 1;
    sprite.scaleY = 1;
    sprite.scaleZ = 1;
    sprite.flipX = false;
    sprite.flipY = false;
    return(sprite);
}

struct Cquad
{
    float x, y;
    int w, h;
    float angleX, angleY, angleZ; // rotacion
    float R, G, B, A;
    float scaleX, scaleY, scaleZ;
};


struct Clevel
{
    char name[30]; // the name of the level
    char hint[60]; // a level hint like: "Match two tiles"
    int screenW; // width of the screen in pixels
    int screenH;
    int tileSpacingH; // margin of the sides of tiles
    int tileSpacingV; // top and bottom margin
    int theme; // number of the theme (tiles & backgrounds)
    int tilesH; // number of tiles placed horizontally
    int tilesV; // number of tiles placed vertically
    // the number of tiles in the level is tilesH * tilesV //
    int match; // tiles to match to get (normally 2)
    int waitTime; // time to wait showing the last unmatched tile touched
    double time; // level timer in seconds
    int hiTime; // top time for the level
    int hiScore; // top score for the level
    int playerScore; // actual player score
    double playerTime; // actual player time
    int combos; // number of combos done
    int comboScore; // score achieved through combos
    int medal; // 0 = no medal, 1 = bronze, 2 = silver, 3 = gold, 4 = ?...

    bool hasSlideBar;

};
Clevel mlevel[MAXLEVELS + 1];

struct Ctile
{
    int id;
    int x, y;
    bool matched, visible;
};
#define TILEW 72
#define TILEH 72
#define MAXTILESH 100
#define MAXTILESV 10
#define TILESHEETCOLS 10
#define TILESHEETROWS 3
Ctile mtile[MAXTILESH][MAXTILESV];

struct Ccamera
{
    int x, y;
    int w, h;
};
Ccamera mcamera;

int levelNumber;
int maxLevel;

Mix_Music *music;
Mix_Chunk *touchSound, *matchSound, *noMatchSound, *comboSound;
int overallVolume = 6;
/* Volume OSD time in secs*/
#define VOLUMEOSDTIME 2
double volumeOSDTime;

#define STATUSBAR_HEIGHT 112
#define STATUSBAR_WIDTH SCREEN_WIDTH
#define PAUSEBUTTON_X 8
#define PAUSEBUTTON_Y SCREEN_HEIGHT - STATUSBAR_HEIGHT

int comboCounter;
int overallScore, overallTime;

int mouseX, mouseY;
bool sliderIsActive;
