/*
 *  xdg utils
 *  Copyright (C) 2009
 *
 *  					Joao Pinto (joao.pinto@getdeb.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
/**
 *  Helper class to work with XDG paths
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <limits.h>
#include "XDGPath.h"

static void recursive_mkdir(const char *dir) {
    char tmp[PATH_MAX];
    char *p = NULL;
    size_t len;
    snprintf(tmp, sizeof(tmp),"%s",dir);
    len = strlen(tmp);
    if(tmp[len - 1] == '/')
        tmp[len - 1] = 0;

    for(p = tmp + 1; *p; p++)
        if(*p == '/') {
            *p = 0;
            mkdir(tmp, S_IRWXU);
            *p = '/';
        }
        mkdir(tmp, S_IRWXU);
}

XDGPath::XDGPath(char* appname)
{
    this->appname = strdup(appname);
}

char* XDGPath::create_config_dir(void)
{
    static char config_dir[PATH_MAX];
    static char app_config_dir[PATH_MAX];

    char *xdg_config_home = getenv("XDG_CONFIG_HOME");
    if(xdg_config_home)
        strncpy(config_dir, xdg_config_home, sizeof(config_dir));
    else {
        char* home_dir = getenv("HOME");
        if(home_dir == NULL) {
            printf("$HOME not defined");
            exit(2);
        }
        strncpy(config_dir, home_dir, sizeof(config_dir));
    }
    snprintf(app_config_dir, sizeof(app_config_dir), "%s/.config/%s", \
        config_dir, this->appname);
    recursive_mkdir(app_config_dir);
    return app_config_dir;
}

