/*
 *  Bubble Train
 *  Copyright (C) 2004  
 *  					Adam Child (adam@dwarfcity.co.uk)
 * 						Craig Marshall (craig@craigmarshall.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
 
 /*
  * A check box control
  */
 
#ifndef CHECKBOX_H
#define CHECKBOX_H

#include "Control.h"
#include "Theme.h"

#define CHECKBOX_SIZE 13  			// Width / Height of the checkbox

class CheckBox : public Control
{
	
private:

	bool checked;					// The checked state
	
public:

	CheckBox(Point pos);
	virtual ~CheckBox();
	
	bool getChecked();				// Get/Set the checked state
	void setChecked(bool state);
	
	// IWidget methods
	virtual void draw(SDL_Surface* screenDest);
	virtual bool mouseDown(int x, int y);
	virtual bool keyPress( SDLKey key, SDLMod mod, Uint16 character );
};

#endif // CHECKBOX_H
